/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.context;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ShutdownException;
import org.apache.derby.iapi.services.monitor.Monitor;

final class SystemContext
extends ContextImpl {
    public void cleanupOnError(Throwable throwable) {
        boolean bl = false;
        if (throwable instanceof StandardException) {
            StandardException standardException = (StandardException)throwable;
            int n = standardException.getSeverity();
            if (n < 40000) {
                return;
            }
            if (n >= 50000) {
                bl = true;
            }
        } else if (throwable instanceof ShutdownException || throwable instanceof ThreadDeath) {
            // empty if block
        }
        if (!bl) {
            this.getContextManager().owningCsf.removeContext(this.getContextManager());
            return;
        }
        try {
            System.err.println("Shutting down due to severe error.");
            Monitor.getStream().printlnWithHeader("Shutting down due to severe error." + throwable.getMessage());
        }
        finally {
            Object var4_6 = null;
            Monitor.getMonitor().shutdown();
        }
    }

    SystemContext(ContextManager contextManager) {
        super(contextManager, "SystemContext");
    }
}

